
ArrayList<Anim> anims = new ArrayList<Anim>();

PImage theFrame = new PImage();

int currentAnim=0;
int currentFrame=0;

int speed=1;
int transiMargin=2;

boolean keyAvailable=true;

Audio currentLoop;
Audio step;
String currentLoopUrl="";

int loaded=0;
String[] dirs;

String rootDir = "world/";

void setup() {
  size(360, 280);
  frameRate(50);
  dirs = listWebDirectory(rootDir);
  audioPresent = loadStrings("audioExist.txt");
  textAlign(CENTER,CENTER);  
}

void draw() {
  if (loaded<dirs.length) {
    background(0);
    noStroke();
    fill(0xFF);
    rect(0, 0, width, (float)loaded*height/dirs.length);
    if (loaded==0) {
      currentLoopUrl = rootDir+"audio/audioLoopDefault.ogg";
      currentLoop = new Audio(currentLoopUrl);
      step = new Audio(rootDir+"audio/step.ogg");
      currentLoop.loop = true;
      currentLoop.play();
    }
    String folderName = dirs[loaded].substring(rootDir.length(), dirs[loaded].length());
    if (folderName.substring(0, 1).equals("D")) {      
      anims.add(new Anim(int(folderName.substring(1, 3)), 
      int(folderName.substring(4, 6)), 
      int(folderName.substring(7, 9)), 
      int(folderName.substring(10, 12)), 
      "D", dirs[loaded]));
    } 
    else if (folderName.substring(0, 1).equals("S")) {
      if (folderName.substring(1, 3).equals("00")) currentAnim=anims.size();
      anims.add(new Anim(int(folderName.substring(1, 3)), 
      int(folderName.substring(1, 3)), 
      0, 0, "S", dirs[loaded]));
    }
    anims.get(anims.size()-1).requestAll();
    loaded++;
  } 
  else {
    background(0);
      ((Anim)anims.get(currentAnim)).display(currentFrame);
      displayDirections();
  if (!focused) {
      noStroke();
      fill(0,0xA0);
      rect(0,0,width,height);
      fill(0xFF);
      text("click to give focus",width/2,height/2);
    }
    if (!keyPressed) keyAvailable=true;
  }
}

void displayDirections() {
  stroke(0x00);
  String thisType=((Anim)anims.get(currentAnim)).type;
  if (thisType.equals("S")) {
    fill(0x00, 0xFF, 0x00);
  } 
  else if (thisType.equals("D")) {
    fill(0x00);
    if (currentFrame<transiMargin || currentFrame>=((Anim)anims.get(currentAnim)).len-transiMargin) fill(0x00, 0xFF, 0x00);
  }
  triangle(5, height/2, 15, height/2-5, 15, height/2+5);
  triangle(width-5, height/2, width-15, height/2-5, width-15, height/2+5);
  if (thisType.equals("D")) {
    fill(0x00, 0xFF, 0x00);
  }
  else if (thisType.equals("S")) {
    fill(0x00);
    for (int i=0;i<anims.size();i++) {
      int[] cTP = closestTransitionPoint();
      if (cTP[0]!=-1 && abs(cTP[1])<transiMargin) fill(0x00, 0xFF, 0x00);
    }
  }
  triangle(width/2, 5, width/2-5, 15, width/2+5, 15);
  if (thisType.equals("D")) {
    fill(0x00, 0xFF, 0x00);
  }
  else if (thisType.equals("S")) {
    fill(0x00);
    for (int i=0;i<anims.size();i++) {
      int[] cTP = closestTransitionPointBackwards();
      if (cTP[0]!=-1 && abs(cTP[1])<transiMargin) fill(0x00, 0xFF, 0x00);
    }
  }
  triangle(width/2, height-5, width/2-5, height-15, width/2+5, height-15);
}

void keyPressed() {
  if (keyAvailable) {
    String currentType = anims.get(currentAnim).type; 
    keyAvailable=false;
    int previousFrame=currentFrame;
    int previousAnim=currentAnim;
    if (keyCode==LEFT || keyCode==RIGHT) {
      if (currentType.equals("D")) {
        if (currentFrame<transiMargin) currentFrame-=speed;
        if (currentFrame>=((Anim)anims.get(currentAnim)).len-transiMargin) currentFrame+=speed;
      }
    }
    if (keyCode==LEFT) {
      if (currentType.equals("S")) currentFrame-=speed;
    }
    if (keyCode==RIGHT) {
      if (currentType.equals("S")) currentFrame+=speed;
    }
    if (keyCode==UP) {
      if (currentType.equals("S")) {
        int[] cTP = closestTransitionPoint();
        if (cTP[0]!=-1 && abs(cTP[1])<transiMargin) {
          if (cTP[1]==0) {
            currentAnim=cTP[0];
            currentType = anims.get(currentAnim).type;
            currentFrame=0;
          }
          else {
            currentFrame+=constrain(cTP[1], -speed, speed);
          }
        }
      } 
      else if (currentType.equals("D")) {
        currentFrame+=speed;
      }
    }    
    if (keyCode==DOWN) {
      if (currentType.equals("D")) {
        currentFrame-=speed;
      } 
      else if (currentType.equals("S")) {
        int[] cTP = closestTransitionPointBackwards();
        if (cTP[0]!=-1 && abs(cTP[1])<transiMargin) {
          if (cTP[1]==0) {
            currentAnim=cTP[0];
            currentType = anims.get(currentAnim).type;
            currentFrame=anims.get(currentAnim).len-1;
          }
          else {
            currentFrame+=constrain(cTP[1], -speed, speed);
          }
        }
      }
    }
    if (currentType.equals("S")) {
      currentFrame=(currentFrame+((Anim)anims.get(currentAnim)).len)%((Anim)anims.get(currentAnim)).len;
    }
    else if (currentType.equals("D")) {
      if (currentFrame<0) {
        int goTo = -1;
        for (int i=0;i<anims.size();i++) {
          String thisType = ((Anim)anims.get(i)).type;
          if (thisType.equals("S") && ((Anim)anims.get(i)).from==((Anim)anims.get(currentAnim)).from) goTo=i;
        }
        currentFrame = ((Anim)anims.get(currentAnim)).fromFrame;
        currentAnim = goTo;
        currentType = anims.get(currentAnim).type;
      }
      else if (currentFrame>=((Anim)anims.get(currentAnim)).len) {
        int goTo = -1;
        for (int i=0;i<anims.size();i++) {
          String thisType = ((Anim)anims.get(i)).type;
          if (thisType.equals("S") && ((Anim)anims.get(i)).from==((Anim)anims.get(currentAnim)).to) goTo=i;
        }
        currentFrame = ((Anim)anims.get(currentAnim)).toFrame;
        currentAnim = goTo;
        currentType = anims.get(currentAnim).type;
      }
    }
    String thisAudioLoopUrl = ((Anim)anims.get(currentAnim)).audioLoop;
    if (!currentLoopUrl.equals(thisAudioLoopUrl)) {
      if (!thisAudioLoopUrl.equals("")) {
        currentLoopUrl = thisAudioLoopUrl;
        currentLoop.pause();
        currentLoop = new Audio(currentLoopUrl);
        currentLoop.loop = true;
        currentLoop.play();
      }
    }
    if (previousFrame!=currentFrame || previousAnim!=currentAnim) step.play();
  }
}

int[] closestTransitionPoint() {
  int[] result = new int[2];
  result[0]=-1;
  result[1]=0;
  String currentType = ((Anim)anims.get(currentAnim)).type;
  for (int i=0;i<anims.size();i++) {
    String thisType = ((Anim)anims.get(i)).type;
    if (thisType.equals("D") && anims.get(i).from==anims.get(currentAnim).from) {
      int thisDistance=((Anim)anims.get(currentAnim)).distanceFrom(((Anim)anims.get(i)).fromFrame);
      if (abs(thisDistance)<abs(result[1]) || result[0]==-1) {
        result[0]=i;
        result[1]=thisDistance;
      }
    }
  }
  return result;
}

int[] closestTransitionPointBackwards() {
  int[] result = new int[2];
  result[0]=-1;
  result[1]=0;
  String currentType = ((Anim)anims.get(currentAnim)).type;
  for (int i=0;i<anims.size();i++) {
    String thisType = ((Anim)anims.get(i)).type;
    if (thisType.equals("D") && ((Anim)anims.get(i)).to==anims.get(currentAnim).from) {
      int thisDistance=((Anim)anims.get(currentAnim)).distanceFrom(((Anim)anims.get(i)).toFrame);
      if (abs(thisDistance)<abs(result[1]) || result[0]==-1) {
        result[0]=i;
        result[1]=thisDistance;
      }
    }
  }
  return result;
}

class Anim {
  String type;
  int len;
  int from;
  int to;  
  int fromFrame;
  int toFrame;
  String url;
  String audioLoop;
  Anim(int from, int to, int fromFrame, int toFrame, String type, String url) {
    this.from=from;
    this.to=to;
    this.fromFrame=fromFrame;
    this.toFrame=toFrame;
    this.type=type;
    this.url=url;
    this.len = listWebDirectory(url).length;
    this.audioLoop="";
    if (audioExist(nf(from, 2))) this.audioLoop=rootDir+"audio/audioLoop"+nf(from, 2)+".ogg";
  }
  void requestAll() {
    for (int i=0;i<len;i++) {
      currentImg = url + nf(i, 4) + ".jpg";
      requestImage(currentImg);
    }
  }
  void display(int frame) {
    if (!currentImg.equals(url + nf(frame, 4) + ".jpg")) {
      currentImg = url + nf(frame, 4) + ".jpg";
      theFrame = requestImage(currentImg);
    }
    if (theFrame.width>0) image(theFrame, 20, 20, 320, 240);
	else text("",width/2,height/3); //else text("loading...",width/2,height/3);
  }
  int distanceFrom(int frame) {
    int d1=frame-currentFrame;
    if (d1>len/2) {
      d1=d1-len;
    }
    if (d1<-len/2) {
      d1=d1+len;
    }
    return d1;
  }
}

String[] audioPresent;
boolean audioExist(String str) {
  for (int i=0;i<audioPresent.length;i++) {
    if (audioPresent[i].equals(str)) {
      return true;
    }
  }
  return false;
}

String currentImg="";

String[] listDirectory(String url) {
  File folder=new File(url);
  File[] filesPath = folder.listFiles();
  String[] result = new String[filesPath.length];
  for (int i=0;i<filesPath.length;i++) {
    result[i]=filesPath[i].toString();
  }
  return result;
}

String[] listWebDirectory(String url) {
  String[] page = loadStrings("listDirs.php?dir="+url);
  for (int i=0;i<page.length;i++) page[i]=url+page[i]+"/";
  return page;
}

boolean startsWith(String haystack, String needle) {
  if (haystack.length()<needle.length()) return false;
  if (haystack.substring(0, needle.length()).equals(needle)) return true;
  return false;
}


