
import java.util.*;

Vector<Anim> anims = new Vector<Anim>();

PImage theFrame = new PImage();

int currentAnim=16;
int currentFrame=0;

int speed=1;
int transiMargin=2;

boolean keyAvailable=true;

import ddf.minim.*;

Minim minim;
AudioPlayer player;
AudioSample step;

String currentLoop="";

void setup() {
  size(360,280);
  frameRate(50);
  minim = new Minim(this);
  player = minim.loadFile(dataPath("audio/audioLoopDefault.mp3"), 2048);
  step = minim.loadSample(dataPath("audio/step.mp3"), 2048);
  player.loop();  
  String[] dirs = listDirectory(dataPath("."));
  for (int i=0;i<dirs.length;i++) {
    String folderName = dirs[i].substring(dataPath(".").length()+1);
    if (folderName.substring(0,1).equals("D")) {
      anims.add(new Anim(int(folderName.substring(1,3)),
      int(folderName.substring(4,6)),
      int(folderName.substring(7,9)),
      int(folderName.substring(10,12)),
      "D",dirs[i]));
    } 
    else if (folderName.substring(0,1).equals("S")) {
      if (int(folderName.substring(1,3))==00) currentAnim=anims.size();
      anims.add(new Anim(int(folderName.substring(1,3)),
      int(folderName.substring(1,3)),
      0,0,"S",dirs[i]));
    }
  }
}

void draw() {
  background(0);
  anims.get(currentAnim).display(currentFrame);
  displayDirections();
  if (!keyPressed) keyAvailable=true;
}

void stop()
{
  step.close();
  player.close();
  minim.stop();
  super.stop();
}

void displayDirections() {
  stroke(0x00);
  if (anims.get(currentAnim).type.equals("S")) {
    fill(0x00,0xFF,0x00);
  } 
  else if (anims.get(currentAnim).type.equals("D")) {
    fill(0x00);
    if (currentFrame<transiMargin || currentFrame>=anims.get(currentAnim).len-transiMargin) fill(0x00,0xFF,0x00);
  }
  triangle(5,height/2,15,height/2-5,15,height/2+5);
  triangle(width-5,height/2,width-15,height/2-5,width-15,height/2+5);

  if (anims.get(currentAnim).type.equals("D")) {
    fill(0x00,0xFF,0x00);
  }
  else if (anims.get(currentAnim).type.equals("S")) {
    fill(0x00);
    for (int i=0;i<anims.size();i++) {
      int[] cTP = closestTransitionPoint();
      if (cTP[0]!=-1 && abs(cTP[1])<transiMargin) fill(0x00,0xFF,0x00);
    }
  }
  triangle(width/2,5,width/2-5,15,width/2+5,15);
  if (anims.get(currentAnim).type.equals("D")) {
    fill(0x00,0xFF,0x00);
  }
  else if (anims.get(currentAnim).type.equals("S")) {
    fill(0x00);
    for (int i=0;i<anims.size();i++) {
      int[] cTP = closestTransitionPointBackwards();
      if (cTP[0]!=-1 && abs(cTP[1])<transiMargin) fill(0x00,0xFF,0x00);
    }
  }
  triangle(width/2,height-5,width/2-5,height-15,width/2+5,height-15);
}

void keyPressed() {
  if (keyAvailable) {
    keyAvailable=false;
    int previousFrame=currentFrame;
    int previousAnim=currentAnim;
    if (keyCode==LEFT || keyCode==RIGHT) {
      if (anims.get(currentAnim).type.equals("D")) {
        if (currentFrame<transiMargin) currentFrame-=speed;
        if (currentFrame>=anims.get(currentAnim).len-transiMargin) currentFrame+=speed;
      }
    }
    if (keyCode==LEFT) {
      if (anims.get(currentAnim).type.equals("S")) currentFrame-=speed;
    }
    if (keyCode==RIGHT) {
      if (anims.get(currentAnim).type.equals("S")) currentFrame+=speed;
    }
    if (keyCode==UP) {
      if (anims.get(currentAnim).type.equals("S")) {
        int[] cTP = closestTransitionPoint();
        if (cTP[0]!=-1 && abs(cTP[1])<transiMargin) {
          if (cTP[1]==0) {
            currentAnim=cTP[0];
            currentFrame=0;
          }
          else {
            currentFrame+=constrain(cTP[1],-speed,speed);
          }
        }
      } 
      else if (anims.get(currentAnim).type.equals("D")) {
        currentFrame+=speed;
      }
    }    
    if (keyCode==DOWN) {
      if (anims.get(currentAnim).type.equals("D")) {
        currentFrame-=speed;
      } 
      else if (anims.get(currentAnim).type.equals("S")) {
        int[] cTP = closestTransitionPointBackwards();
        if (cTP[0]!=-1 && abs(cTP[1])<transiMargin) {
          if (cTP[1]==0) {
            currentAnim=cTP[0];
            currentFrame=anims.get(currentAnim).len-1;
          }
          else {
            currentFrame+=constrain(cTP[1],-speed,speed);
          }
        }
      }
    }
    if (anims.get(currentAnim).type.equals("S")) {
      currentFrame=(currentFrame+anims.get(currentAnim).len)%anims.get(currentAnim).len;
    } 
    else if (anims.get(currentAnim).type.equals("D")) {
      if (currentFrame<0) {
        int goTo = -1;
        for (int i=0;i<anims.size();i++) {
          if (anims.get(i).type.equals("S") && anims.get(i).from==anims.get(currentAnim).from) goTo=i;
        }
        currentFrame = anims.get(currentAnim).fromFrame;
        currentAnim = goTo;
      }
      else if (currentFrame>=anims.get(currentAnim).len) {
        int goTo = -1;
        for (int i=0;i<anims.size();i++) {
          if (anims.get(i).type.equals("S") && anims.get(i).from==anims.get(currentAnim).to) goTo=i;
        }
        currentFrame = anims.get(currentAnim).toFrame;
        currentAnim = goTo;
      }
    }
    if (!currentLoop.equals(anims.get(currentAnim).audioLoop)) {
      if (!anims.get(currentAnim).audioLoop.equals("")) {
        currentLoop=anims.get(currentAnim).audioLoop;
        player.pause();
        player = minim.loadFile(anims.get(currentAnim).audioLoop, 2048);
        player.loop();
      }
    }
    if (previousFrame!=currentFrame || previousAnim!=currentAnim) step.trigger();
  }
}

int[] closestTransitionPoint() {
  int[] result = new int[2];
  result[0]=-1;
  result[1]=0;
  for (int i=0;i<anims.size();i++) {
    if (anims.get(i).type.equals("D") && anims.get(i).from==anims.get(currentAnim).from) {
      int thisDistance=anims.get(currentAnim).distanceFrom(anims.get(i).fromFrame);
      if (abs(thisDistance)<abs(result[1]) || result[0]==-1) {
        result[0]=i;
        result[1]=thisDistance;
      }
    }
  }
  return result;
}

int[] closestTransitionPointBackwards() {
  int[] result = new int[2];
  result[0]=-1;
  result[1]=0;
  for (int i=0;i<anims.size();i++) {
    if (anims.get(i).type.equals("D") && anims.get(i).to==anims.get(currentAnim).from) {
      int thisDistance=anims.get(currentAnim).distanceFrom(anims.get(i).toFrame);
      if (abs(thisDistance)<abs(result[1]) || result[0]==-1) {
        result[0]=i;
        result[1]=thisDistance;
      }
    }
  }
  return result;
}

class Anim {
  String type;
  int len;
  int from;
  int to;  
  int fromFrame;
  int toFrame;
  String url;
  String audioLoop;
  Anim(int from, int to, int fromFrame, int toFrame, String type, String url) {
    this.from=from;
    this.to=to;
    this.fromFrame=fromFrame;
    this.toFrame=toFrame;
    this.type=type;
    this.url=url;
    this.len = listDirectory(url).length;
    File file = new File(dataPath("audio/audioLoop"+nf(from,2)+".mp3"));
    this.audioLoop="";
    if(file.exists())this.audioLoop=dataPath("audio/audioLoop"+nf(from,2)+".mp3");
  }
  void display(int frame) {
    theFrame = loadImage(url + "/" + nf(frame,4) + ".jpg");
    image(theFrame,20,20,320,240);
  }
  int distanceFrom(int frame) {
    int d1=frame-currentFrame;
    if (d1>len/2) {
      d1=d1-len;
    }
    if (d1<-len/2) {
      d1=d1+len;
    }
    return d1;
  }
}

String[] listDirectory(String url) {
  File folder=new File(url);
  File[] filesPath = folder.listFiles();
  String[] result = new String[filesPath.length];
  for (int i=0;i<filesPath.length;i++) {
    result[i]=filesPath[i].toString();
  }
  return result;
}

